package abstraction;
/**
 * 
 * @author Chiara Coccia, Diego Colarullo
 * @version 1.2 09/03/18
 * @since JDK 1.6
 */
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdfparser.PDFParser;
import java.io.*;

import org.pdfbox.util.PDFTextStripper;

/**
 * 
 * This class has only a one method that takes a PDF file, reads and transform it in a String.
 * To read from PDF file have been used library pdfbox.
 */
public class ConvertPdf {
	/**
	 * 
	 * @param filename name's file to take in input
	 * @return a string with content's file
     * @throws IOException If there is an error releasing resources with clousure document
	 * @exception IOException If an I/O error occurs
	 * @exception NoClassDefFoundError if not found class
	 * @exception if catch some exception
	 */
	protected static String  GetTextFromPdf(String filename) throws IOException, NoClassDefFoundError, Exception{
        String contentFile="";	  
        PDDocument document=null;             	        	
            InputStream in=new FileInputStream(filename);           
    		StringWriter out=new StringWriter();         	
			PDFTextStripper stripper = new PDFTextStripper();	
		    PDFParser parser = new PDFParser(in);			    
		    parser.parse();	    
		    document = parser.getPDDocument();			    
		    stripper.writeText(document,out);		    
		    contentFile=out.toString();	   
			document.close();		    
		return contentFile;		
	}
}
	
	

